/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.cec;

import com.ibm.hsc.auiml.databeans.cec.HSCResRecoverBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.websm.lpar.DlparAdapterDialog;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import java.util.Hashtable;
import java.util.Vector;

public class HSCAdapterRecoverBean
extends HSCResRecoverBean {
    protected static final String SLOT_INFO_DLPAR = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SLOT_INFO_DLPAR", "The adapters listed below may be available for adding, but are in an unusable state.  The adapters may be in this state temporarily because of a DLPAR operation in progress.  Select \"Help\" for other reasons why the adapters may be in this state. If you are sure that no dynamic reconfiguration operations are in progress,  you may unassign stopped adapters by highlighting the desired adapters in the table below and then selecting \"Unassign\".  The unassigned adapters can then be added to this partition.");
    protected static final String SLOT_INFO_ACTIVATE = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SLOT_INFO_ACTIVATE", "The partition cannot be activated because one or more required adapters are not free to use. However, the required adapters in the table below may still be available; they are stopped but are still assigned to running partitions. Select \"Help\" for explanations as to how this might have happened.  If no DLPAR operations are in progress, you may unassign adapters by highlighting desired adapters and then selecting \"Unassign\".  The unassigned adapters can then be used to activate the partition.");
    protected Vector mDrawerIds = null;
    protected Vector mSlots = null;
    protected Vector mTypes = null;
    protected Vector mStates = null;
    protected String[] mDrawerColStr;
    protected ItemDescriptor[] mDrawerColId;
    protected String[] mSlotColStr;
    protected ItemDescriptor[] mSlotColId;
    protected String[] mStateColStr;
    protected ItemDescriptor[] mStateColId;
    protected String[] mTypeColStr;
    protected ItemDescriptor[] mTypeColId;

    public HSCAdapterRecoverBean() {
        this.mPanelName = "RecoverAdapters";
        this.mAuimlClassName = "com.ibm.hsc.auiml.databeans.cec.AdapterRecover";
    }

    protected void loadRecoverData(Hashtable hashtable) {
        this.mDrawerIds = (Vector)hashtable.get("IODrawerDeviceID");
        this.mSlots = (Vector)hashtable.get("SlotID");
        this.mTypes = (Vector)hashtable.get("ClassCodeInfo");
        this.mStates = (Vector)hashtable.get("State");
        this.mParNames = (Vector)hashtable.get("partitionNameUser");
        this.mParIntNames = (Vector)hashtable.get("partitionNameInt");
    }

    private void loadBackendData() throws Exception {
        if (this.mParNames == null) {
            Hashtable hashtable = this.loadDataFromServer("getSlotRecoverInfo");
            this.loadRecoverData(hashtable);
        }
        int n = this.mParNames.size();
        this.mDrawerColId = new ItemDescriptor[n];
        this.mSlotColId = new ItemDescriptor[n];
        this.mTypeColId = new ItemDescriptor[n];
        this.mStateColId = new ItemDescriptor[n];
        this.mParColId = new ItemDescriptor[n];
        for (int i = 0; i < this.mParNames.size(); ++i) {
            String string = (String)this.mParNames.elementAt(i);
            String string2 = (String)this.mDrawerIds.elementAt(i);
            String string3 = "" + this.mSlots.elementAt(i);
            String string4 = (String)this.mTypes.elementAt(i);
            String string5 = "" + this.mStates.elementAt(i);
            this.mParColId[i] = new ItemDescriptor("par" + i, string);
            this.mDrawerColId[i] = new ItemDescriptor("drawer" + i, string2);
            this.mSlotColId[i] = new ItemDescriptor("slot" + i, string3);
            this.mTypeColId[i] = new ItemDescriptor("type" + i, string4);
            this.mStateColId[i] = new ItemDescriptor("state" + i, string5);
        }
    }

    protected boolean saveChanges() throws Exception {
        int n;
        int[] nArray = this.getRecoverTableSelection();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            vector.addElement(this.mDrawerIds.elementAt(n2));
            vector2.addElement(this.mSlots.elementAt(n2));
        }
        for (n = 0; n < vector.size(); ++n) {
            System.out.println("sel drawer: " + vector.elementAt(n));
            System.out.println("sel slot: " + vector2.elementAt(n));
        }
        Object[] objectArray = new Object[]{vector, vector2};
        return this.saveDataToServer("recoverSlot", objectArray);
    }

    protected void showDLPARDialog() {
        if (this.mLparContainer != null) {
            DlparAdapterDialog.showDialog(this.mLparContainer);
        }
    }

    public void setDrawerColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mDrawerColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getDrawerColList() {
        return this.mDrawerColId;
    }

    public String[] getDrawerColSelection() {
        return this.mDrawerColStr;
    }

    public void setDrawerColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mDrawerColStr = stringArray;
    }

    public void setSlotColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mSlotColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getSlotColList() {
        return this.mSlotColId;
    }

    public String[] getSlotColSelection() {
        return this.mSlotColStr;
    }

    public void setSlotColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mSlotColStr = stringArray;
    }

    public void setStateColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mStateColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getStateColList() {
        return this.mStateColId;
    }

    public String[] getStateColSelection() {
        return this.mStateColStr;
    }

    public void setStateColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mStateColStr = stringArray;
    }

    public void setTypeColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mTypeColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getTypeColList() {
        return this.mTypeColId;
    }

    public String[] getTypeColSelection() {
        return this.mTypeColStr;
    }

    public void setTypeColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mTypeColStr = stringArray;
    }

    public void load() {
        try {
            this.mLoadException = null;
            super.load();
            this.mDrawerColStr = new String[0];
            this.mDrawerColId = new ItemDescriptor[0];
            this.mSlotColStr = new String[0];
            this.mSlotColId = new ItemDescriptor[0];
            this.mStateColStr = new String[0];
            this.mStateColId = new ItemDescriptor[0];
            this.mTypeColStr = new String[0];
            this.mTypeColId = new ItemDescriptor[0];
            this.loadBackendData();
            this.mInfoArea = this.mFromActivate ? SLOT_INFO_ACTIVATE : SLOT_INFO_DLPAR;
        }
        catch (Throwable throwable) {
            this.mLoadException = throwable;
            this.handleException(throwable, this.mActivateMsg);
        }
    }
}

